// Borland C++ Builder
// Copyright (c) 1995, 2005 by Borland Software Corporation
// All rights reserved

// (DO NOT EDIT: machine generated header) 'Dialogs.pas' rev: 10.00

#ifndef DialogsHPP
#define DialogsHPP

#pragma delphiheader begin
#pragma option push
#pragma option -w-      // All warnings off
#pragma option -Vx      // Zero-length empty class member functions
#pragma pack(push,8)
#include <System.hpp>	// Pascal unit
#include <Sysinit.hpp>	// Pascal unit
#include <Windows.hpp>	// Pascal unit
#include <Messages.hpp>	// Pascal unit
#include <Sysutils.hpp>	// Pascal unit
#include <Commdlg.hpp>	// Pascal unit
#include <Printers.hpp>	// Pascal unit
#include <Classes.hpp>	// Pascal unit
#include <Graphics.hpp>	// Pascal unit
#include <Controls.hpp>	// Pascal unit
#include <Forms.hpp>	// Pascal unit
#include <Stdctrls.hpp>	// Pascal unit
#include <Shlobj.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------

namespace Dialogs
{
//-- type declarations -------------------------------------------------------
class DELPHICLASS TCommonDialog;
class PASCALIMPLEMENTATION TCommonDialog : public Classes::TComponent 
{
	typedef Classes::TComponent inherited;
	
private:
	bool FCtl3D;
	void *FDefWndProc;
	Classes::THelpContext FHelpContext;
	HWND FHandle;
	Controls::TWinControl* FRedirector;
	void *FObjectInstance;
	char *FTemplate;
	unsigned FTemplateModule;
	Classes::TNotifyEvent FOnClose;
	Classes::TNotifyEvent FOnShow;
	MESSAGE void __fastcall WMDestroy(Messages::TWMNoParams &Message);
	MESSAGE void __fastcall WMInitDialog(Messages::TWMInitDialog &Message);
	MESSAGE void __fastcall WMNCDestroy(Messages::TWMNoParams &Message);
	void __fastcall MainWndProc(Messages::TMessage &Message);
	
protected:
	DYNAMIC void __fastcall DoClose(void);
	DYNAMIC void __fastcall DoShow(void);
	virtual void __fastcall WndProc(Messages::TMessage &Message);
	virtual bool __fastcall MessageHook(Messages::TMessage &Msg);
	virtual BOOL __fastcall TaskModalDialog(void * DialogFunc, void *DialogData);
	__property char * Template = {read=FTemplate, write=FTemplate};
	__property unsigned TemplateModule = {read=FTemplateModule, write=FTemplateModule, nodefault};
	
public:
	__fastcall virtual TCommonDialog(Classes::TComponent* AOwner);
	__fastcall virtual ~TCommonDialog(void);
	virtual bool __fastcall Execute(void)/* overload */;
	virtual bool __fastcall Execute(HWND ParentWnd) = 0 /* overload */;
	virtual void __fastcall DefaultHandler(void *Message);
	__property HWND Handle = {read=FHandle, nodefault};
	
__published:
	__property bool Ctl3D = {read=FCtl3D, write=FCtl3D, default=1};
	__property Classes::THelpContext HelpContext = {read=FHelpContext, write=FHelpContext, default=0};
	__property Classes::TNotifyEvent OnClose = {read=FOnClose, write=FOnClose};
	__property Classes::TNotifyEvent OnShow = {read=FOnShow, write=FOnShow};
};


#pragma option push -b-
enum TOpenOption { ofReadOnly, ofOverwritePrompt, ofHideReadOnly, ofNoChangeDir, ofShowHelp, ofNoValidate, ofAllowMultiSelect, ofExtensionDifferent, ofPathMustExist, ofFileMustExist, ofCreatePrompt, ofShareAware, ofNoReadOnlyReturn, ofNoTestFileCreate, ofNoNetworkButton, ofNoLongNames, ofOldStyleDialog, ofNoDereferenceLinks, ofEnableIncludeNotify, ofEnableSizing, ofDontAddToRecent, ofForceShowHidden };
#pragma option pop

typedef Set<TOpenOption, ofReadOnly, ofForceShowHidden>  TOpenOptions;

#pragma option push -b-
enum TOpenOptionEx { ofExNoPlacesBar };
#pragma option pop

typedef Set<TOpenOptionEx, ofExNoPlacesBar, ofExNoPlacesBar>  TOpenOptionsEx;

#pragma option push -b-
enum TFileEditStyle { fsEdit, fsComboBox };
#pragma option pop

typedef void __fastcall (__closure *TIncludeItemEvent)(const TOFNotifyEx &OFN, bool &Include);

class DELPHICLASS TOpenDialog;
class PASCALIMPLEMENTATION TOpenDialog : public TCommonDialog 
{
	typedef TCommonDialog inherited;
	
private:
	Classes::TStrings* FHistoryList;
	TOpenOptions FOptions;
	AnsiString FFilter;
	int FFilterIndex;
	int FCurrentFilterIndex;
	AnsiString FInitialDir;
	AnsiString FTitle;
	AnsiString FDefaultExt;
	AnsiString FFileName;
	Classes::TStrings* FFiles;
	TFileEditStyle FFileEditStyle;
	Classes::TNotifyEvent FOnSelectionChange;
	Classes::TNotifyEvent FOnFolderChange;
	Classes::TNotifyEvent FOnTypeChange;
	Forms::TCloseQueryEvent FOnCanClose;
	TIncludeItemEvent FOnIncludeItem;
	TOpenOptionsEx FOptionsEx;
	AnsiString __fastcall GetFileName();
	int __fastcall GetFilterIndex(void);
	void __fastcall ReadFileEditStyle(Classes::TReader* Reader);
	void __fastcall SetHistoryList(Classes::TStrings* Value);
	void __fastcall SetInitialDir(const AnsiString Value);
	
protected:
	bool __fastcall CanClose(tagOFNA &OpenFileName);
	DYNAMIC bool __fastcall DoCanClose(void);
	BOOL __fastcall DoExecute(void * Func)/* overload */;
	BOOL __fastcall DoExecute(void * Func, HWND ParentWnd)/* overload */;
	DYNAMIC void __fastcall DoSelectionChange(void);
	DYNAMIC void __fastcall DoFolderChange(void);
	DYNAMIC void __fastcall DoTypeChange(void);
	DYNAMIC void __fastcall DoIncludeItem(const TOFNotifyEx &OFN, bool &Include);
	virtual void __fastcall DefineProperties(Classes::TFiler* Filer);
	void __fastcall GetFileNames(tagOFNA &OpenFileName);
	virtual Types::TRect __fastcall GetStaticRect();
	virtual void __fastcall WndProc(Messages::TMessage &Message);
	
public:
	__fastcall virtual TOpenDialog(Classes::TComponent* AOwner);
	__fastcall virtual ~TOpenDialog(void);
	virtual bool __fastcall Execute(HWND ParentWnd)/* overload */;
	__property TFileEditStyle FileEditStyle = {read=FFileEditStyle, write=FFileEditStyle, nodefault};
	__property Classes::TStrings* Files = {read=FFiles};
	__property Classes::TStrings* HistoryList = {read=FHistoryList, write=SetHistoryList};
	
__published:
	__property AnsiString DefaultExt = {read=FDefaultExt, write=FDefaultExt};
	__property AnsiString FileName = {read=GetFileName, write=FFileName};
	__property AnsiString Filter = {read=FFilter, write=FFilter};
	__property int FilterIndex = {read=GetFilterIndex, write=FFilterIndex, default=1};
	__property AnsiString InitialDir = {read=FInitialDir, write=SetInitialDir};
	__property TOpenOptions Options = {read=FOptions, write=FOptions, default=524292};
	__property TOpenOptionsEx OptionsEx = {read=FOptionsEx, write=FOptionsEx, default=0};
	__property AnsiString Title = {read=FTitle, write=FTitle};
	__property Forms::TCloseQueryEvent OnCanClose = {read=FOnCanClose, write=FOnCanClose};
	__property Classes::TNotifyEvent OnFolderChange = {read=FOnFolderChange, write=FOnFolderChange};
	__property Classes::TNotifyEvent OnSelectionChange = {read=FOnSelectionChange, write=FOnSelectionChange};
	__property Classes::TNotifyEvent OnTypeChange = {read=FOnTypeChange, write=FOnTypeChange};
	__property TIncludeItemEvent OnIncludeItem = {read=FOnIncludeItem, write=FOnIncludeItem};
	
/* Hoisted overloads: */
	
public:
	inline bool __fastcall  Execute(void){ return TCommonDialog::Execute(); }
	
};


class DELPHICLASS TSaveDialog;
class PASCALIMPLEMENTATION TSaveDialog : public TOpenDialog 
{
	typedef TOpenDialog inherited;
	
__published:
	virtual bool __fastcall Execute(HWND ParentWnd)/* overload */;
public:
	#pragma option push -w-inl
	/* TOpenDialog.Create */ inline __fastcall virtual TSaveDialog(Classes::TComponent* AOwner) : TOpenDialog(AOwner) { }
	#pragma option pop
	#pragma option push -w-inl
	/* TOpenDialog.Destroy */ inline __fastcall virtual ~TSaveDialog(void) { }
	#pragma option pop
	
	
/* Hoisted overloads: */
	
public:
	inline bool __fastcall  Execute(void){ return TCommonDialog::Execute(); }
	
};


#pragma option push -b-
enum TColorDialogOption { cdFullOpen, cdPreventFullOpen, cdShowHelp, cdSolidColor, cdAnyColor };
#pragma option pop

typedef Set<TColorDialogOption, cdFullOpen, cdAnyColor>  TColorDialogOptions;

typedef int TCustomColors[16];

class DELPHICLASS TColorDialog;
class PASCALIMPLEMENTATION TColorDialog : public TCommonDialog 
{
	typedef TCommonDialog inherited;
	
private:
	Graphics::TColor FColor;
	TColorDialogOptions FOptions;
	Classes::TStrings* FCustomColors;
	void __fastcall SetCustomColors(Classes::TStrings* Value);
	
public:
	__fastcall virtual TColorDialog(Classes::TComponent* AOwner);
	__fastcall virtual ~TColorDialog(void);
	virtual bool __fastcall Execute(HWND ParentWnd)/* overload */;
	
__published:
	__property Graphics::TColor Color = {read=FColor, write=FColor, default=0};
	__property Ctl3D  = {default=1};
	__property Classes::TStrings* CustomColors = {read=FCustomColors, write=SetCustomColors};
	__property TColorDialogOptions Options = {read=FOptions, write=FOptions, default=0};
	
/* Hoisted overloads: */
	
public:
	inline bool __fastcall  Execute(void){ return TCommonDialog::Execute(); }
	
};


#pragma option push -b-
enum TFontDialogOption { fdAnsiOnly, fdTrueTypeOnly, fdEffects, fdFixedPitchOnly, fdForceFontExist, fdNoFaceSel, fdNoOEMFonts, fdNoSimulations, fdNoSizeSel, fdNoStyleSel, fdNoVectorFonts, fdShowHelp, fdWysiwyg, fdLimitSize, fdScalableOnly, fdApplyButton };
#pragma option pop

typedef Set<TFontDialogOption, fdAnsiOnly, fdApplyButton>  TFontDialogOptions;

#pragma option push -b-
enum TFontDialogDevice { fdScreen, fdPrinter, fdBoth };
#pragma option pop

typedef void __fastcall (__closure *TFDApplyEvent)(System::TObject* Sender, HWND Wnd);

class DELPHICLASS TFontDialog;
class PASCALIMPLEMENTATION TFontDialog : public TCommonDialog 
{
	typedef TCommonDialog inherited;
	
private:
	Graphics::TFont* FFont;
	TFontDialogDevice FDevice;
	TFontDialogOptions FOptions;
	TFDApplyEvent FOnApply;
	int FMinFontSize;
	int FMaxFontSize;
	bool FFontCharsetModified;
	bool FFontColorModified;
	void __fastcall DoApply(HWND Wnd);
	void __fastcall SetFont(Graphics::TFont* Value);
	void __fastcall UpdateFromLogFont(const tagLOGFONTA &LogFont);
	
protected:
	DYNAMIC void __fastcall Apply(HWND Wnd);
	virtual void __fastcall WndProc(Messages::TMessage &Message);
	
public:
	__fastcall virtual TFontDialog(Classes::TComponent* AOwner);
	__fastcall virtual ~TFontDialog(void);
	virtual bool __fastcall Execute(HWND ParentWnd)/* overload */;
	
__published:
	__property Graphics::TFont* Font = {read=FFont, write=SetFont};
	__property TFontDialogDevice Device = {read=FDevice, write=FDevice, default=0};
	__property int MinFontSize = {read=FMinFontSize, write=FMinFontSize, default=0};
	__property int MaxFontSize = {read=FMaxFontSize, write=FMaxFontSize, default=0};
	__property TFontDialogOptions Options = {read=FOptions, write=FOptions, default=4};
	__property TFDApplyEvent OnApply = {read=FOnApply, write=FOnApply};
	
/* Hoisted overloads: */
	
public:
	inline bool __fastcall  Execute(void){ return TCommonDialog::Execute(); }
	
};


class DELPHICLASS TPrinterSetupDialog;
class PASCALIMPLEMENTATION TPrinterSetupDialog : public TCommonDialog 
{
	typedef TCommonDialog inherited;
	
public:
	virtual bool __fastcall Execute(HWND ParentWnd)/* overload */;
public:
	#pragma option push -w-inl
	/* TCommonDialog.Create */ inline __fastcall virtual TPrinterSetupDialog(Classes::TComponent* AOwner) : TCommonDialog(AOwner) { }
	#pragma option pop
	#pragma option push -w-inl
	/* TCommonDialog.Destroy */ inline __fastcall virtual ~TPrinterSetupDialog(void) { }
	#pragma option pop
	
	
/* Hoisted overloads: */
	
public:
	inline bool __fastcall  Execute(void){ return TCommonDialog::Execute(); }
	
};


#pragma option push -b-
enum TPrintRange { prAllPages, prSelection, prPageNums };
#pragma option pop

#pragma option push -b-
enum TPrintDialogOption { poPrintToFile, poPageNums, poSelection, poWarning, poHelp, poDisablePrintToFile };
#pragma option pop

typedef Set<TPrintDialogOption, poPrintToFile, poDisablePrintToFile>  TPrintDialogOptions;

class DELPHICLASS TPrintDialog;
class PASCALIMPLEMENTATION TPrintDialog : public TCommonDialog 
{
	typedef TCommonDialog inherited;
	
private:
	int FFromPage;
	int FToPage;
	bool FCollate;
	TPrintDialogOptions FOptions;
	bool FPrintToFile;
	TPrintRange FPrintRange;
	int FMinPage;
	int FMaxPage;
	int FCopies;
	void __fastcall SetNumCopies(int Value);
	
public:
	virtual bool __fastcall Execute(HWND ParentWnd)/* overload */;
	
__published:
	__property bool Collate = {read=FCollate, write=FCollate, default=0};
	__property int Copies = {read=FCopies, write=SetNumCopies, default=0};
	__property int FromPage = {read=FFromPage, write=FFromPage, default=0};
	__property int MinPage = {read=FMinPage, write=FMinPage, default=0};
	__property int MaxPage = {read=FMaxPage, write=FMaxPage, default=0};
	__property TPrintDialogOptions Options = {read=FOptions, write=FOptions, default=0};
	__property bool PrintToFile = {read=FPrintToFile, write=FPrintToFile, default=0};
	__property TPrintRange PrintRange = {read=FPrintRange, write=FPrintRange, default=0};
	__property int ToPage = {read=FToPage, write=FToPage, default=0};
public:
	#pragma option push -w-inl
	/* TCommonDialog.Create */ inline __fastcall virtual TPrintDialog(Classes::TComponent* AOwner) : TCommonDialog(AOwner) { }
	#pragma option pop
	#pragma option push -w-inl
	/* TCommonDialog.Destroy */ inline __fastcall virtual ~TPrintDialog(void) { }
	#pragma option pop
	
	
/* Hoisted overloads: */
	
public:
	inline bool __fastcall  Execute(void){ return TCommonDialog::Execute(); }
	
};


typedef Printers::TPrinterOrientation TPrinterOrientation;

#pragma option push -b-
enum TPageSetupDialogOption { psoDefaultMinMargins, psoDisableMargins, psoDisableOrientation, psoDisablePagePainting, psoDisablePaper, psoDisablePrinter, psoMargins, psoMinMargins, psoShowHelp, psoWarning, psoNoNetworkButton };
#pragma option pop

typedef Set<TPageSetupDialogOption, psoDefaultMinMargins, psoNoNetworkButton>  TPageSetupDialogOptions;

#pragma option push -b-
enum TPrinterKind { pkDotMatrix, pkHPPCL };
#pragma option pop

#pragma option push -b-
enum TPageType { ptEnvelope, ptPaper };
#pragma option pop

typedef void __fastcall (__closure *TPageSetupBeforePaintEvent)(System::TObject* Sender, const short PaperSize, const Printers::TPrinterOrientation Orientation, const TPageType PageType, bool &DoneDrawing);

#pragma option push -b-
enum TPageMeasureUnits { pmDefault, pmMillimeters, pmInches };
#pragma option pop

typedef void __fastcall (__closure *TPaintPageEvent)(System::TObject* Sender, Graphics::TCanvas* Canvas, const Types::TRect &PageRect, bool &DoneDrawing);

class DELPHICLASS TPageSetupDialog;
class PASCALIMPLEMENTATION TPageSetupDialog : public TCommonDialog 
{
	typedef TCommonDialog inherited;
	
private:
	TPageSetupDialogOptions FOptions;
	int FMinMarginLeft;
	int FMinMarginTop;
	int FMinMarginRight;
	int FMinMarginBottom;
	int FMarginLeft;
	int FMarginTop;
	int FMarginRight;
	int FMarginBottom;
	int FPageWidth;
	int FPageHeight;
	#pragma pack(push,1)
	tagPSDA FPageSetupDlgRec;
	#pragma pack(pop)
	TPageSetupBeforePaintEvent FBeforePaint;
	TPageMeasureUnits FUnits;
	TPaintPageEvent FOnDrawRetAddress;
	TPaintPageEvent FOnDrawMinMargin;
	TPaintPageEvent FOnDrawEnvStamp;
	TPaintPageEvent FOnDrawFullPage;
	TPaintPageEvent FOnDrawGreekText;
	TPaintPageEvent FOnDrawMargin;
	
public:
	__fastcall virtual TPageSetupDialog(Classes::TComponent* AOwner);
	virtual bool __fastcall Execute(HWND ParentWnd)/* overload */;
	bool __fastcall GetDefaults(void);
	__property tagPSDA PageSetupDlgRec = {read=FPageSetupDlgRec};
	
__published:
	__property int MinMarginLeft = {read=FMinMarginLeft, write=FMinMarginLeft, nodefault};
	__property int MinMarginTop = {read=FMinMarginTop, write=FMinMarginTop, nodefault};
	__property int MinMarginRight = {read=FMinMarginRight, write=FMinMarginRight, nodefault};
	__property int MinMarginBottom = {read=FMinMarginBottom, write=FMinMarginBottom, nodefault};
	__property int MarginLeft = {read=FMarginLeft, write=FMarginLeft, nodefault};
	__property int MarginTop = {read=FMarginTop, write=FMarginTop, nodefault};
	__property int MarginRight = {read=FMarginRight, write=FMarginRight, nodefault};
	__property int MarginBottom = {read=FMarginBottom, write=FMarginBottom, nodefault};
	__property TPageSetupDialogOptions Options = {read=FOptions, write=FOptions, default=1};
	__property int PageWidth = {read=FPageWidth, write=FPageWidth, nodefault};
	__property int PageHeight = {read=FPageHeight, write=FPageHeight, nodefault};
	__property TPageMeasureUnits Units = {read=FUnits, write=FUnits, default=0};
	__property TPageSetupBeforePaintEvent BeforePaint = {read=FBeforePaint, write=FBeforePaint};
	__property TPaintPageEvent OnDrawFullPage = {read=FOnDrawFullPage, write=FOnDrawFullPage};
	__property TPaintPageEvent OnDrawMinMargin = {read=FOnDrawMinMargin, write=FOnDrawMinMargin};
	__property TPaintPageEvent OnDrawMargin = {read=FOnDrawMargin, write=FOnDrawMargin};
	__property TPaintPageEvent OnDrawGreekText = {read=FOnDrawGreekText, write=FOnDrawGreekText};
	__property TPaintPageEvent OnDrawEnvStamp = {read=FOnDrawEnvStamp, write=FOnDrawEnvStamp};
	__property TPaintPageEvent OnDrawRetAddress = {read=FOnDrawRetAddress, write=FOnDrawRetAddress};
public:
	#pragma option push -w-inl
	/* TCommonDialog.Destroy */ inline __fastcall virtual ~TPageSetupDialog(void) { }
	#pragma option pop
	
	
/* Hoisted overloads: */
	
public:
	inline bool __fastcall  Execute(void){ return TCommonDialog::Execute(); }
	
};


#pragma option push -b-
enum TFindOption { frDown, frFindNext, frHideMatchCase, frHideWholeWord, frHideUpDown, frMatchCase, frDisableMatchCase, frDisableUpDown, frDisableWholeWord, frReplace, frReplaceAll, frWholeWord, frShowHelp };
#pragma option pop

typedef Set<TFindOption, frDown, frShowHelp>  TFindOptions;

typedef HWND __stdcall (*TFindReplaceFunc)(tagFINDREPLACEA &FindReplace);

class DELPHICLASS TFindDialog;
class PASCALIMPLEMENTATION TFindDialog : public TCommonDialog 
{
	typedef TCommonDialog inherited;
	
private:
	TFindOptions FOptions;
	#pragma pack(push,1)
	Types::TPoint FPosition;
	#pragma pack(pop)
	TFindReplaceFunc FFindReplaceFunc;
	Classes::TNotifyEvent FOnFind;
	Classes::TNotifyEvent FOnReplace;
	HWND FFindHandle;
	#pragma pack(push,1)
	tagFINDREPLACEA FFindReplace;
	#pragma pack(pop)
	char FFindText[256];
	char FReplaceText[256];
	AnsiString __fastcall GetFindText();
	int __fastcall GetLeft(void);
	Types::TPoint __fastcall GetPosition();
	AnsiString __fastcall GetReplaceText();
	int __fastcall GetTop(void);
	void __fastcall SetFindText(const AnsiString Value);
	void __fastcall SetLeft(int Value);
	void __fastcall SetPosition(const Types::TPoint &Value);
	void __fastcall SetReplaceText(const AnsiString Value);
	void __fastcall SetTop(int Value);
	__property AnsiString ReplaceText = {read=GetReplaceText, write=SetReplaceText};
	__property Classes::TNotifyEvent OnReplace = {read=FOnReplace, write=FOnReplace};
	
protected:
	virtual bool __fastcall MessageHook(Messages::TMessage &Msg);
	DYNAMIC void __fastcall Find(void);
	DYNAMIC void __fastcall Replace(void);
	
public:
	__fastcall virtual TFindDialog(Classes::TComponent* AOwner);
	__fastcall virtual ~TFindDialog(void);
	void __fastcall CloseDialog(void);
	virtual bool __fastcall Execute(HWND ParentWnd)/* overload */;
	__property int Left = {read=GetLeft, write=SetLeft, nodefault};
	__property Types::TPoint Position = {read=GetPosition, write=SetPosition};
	__property int Top = {read=GetTop, write=SetTop, nodefault};
	
__published:
	__property AnsiString FindText = {read=GetFindText, write=SetFindText};
	__property TFindOptions Options = {read=FOptions, write=FOptions, default=1};
	__property Classes::TNotifyEvent OnFind = {read=FOnFind, write=FOnFind};
	
/* Hoisted overloads: */
	
public:
	inline bool __fastcall  Execute(void){ return TCommonDialog::Execute(); }
	
};


class DELPHICLASS TReplaceDialog;
class PASCALIMPLEMENTATION TReplaceDialog : public TFindDialog 
{
	typedef TFindDialog inherited;
	
public:
	__fastcall virtual TReplaceDialog(Classes::TComponent* AOwner);
	
__published:
	__property ReplaceText ;
	__property OnReplace ;
public:
	#pragma option push -w-inl
	/* TFindDialog.Destroy */ inline __fastcall virtual ~TReplaceDialog(void) { }
	#pragma option pop
	
};


#pragma option push -b-
enum TMsgDlgType { mtWarning, mtError, mtInformation, mtConfirmation, mtCustom };
#pragma option pop

#pragma option push -b-
enum TMsgDlgBtn { mbYes, mbNo, mbOK, mbCancel, mbAbort, mbRetry, mbIgnore, mbAll, mbNoToAll, mbYesToAll, mbHelp };
#pragma option pop

typedef Set<TMsgDlgBtn, mbYes, mbHelp>  TMsgDlgButtons;

//-- var, const, procedure ---------------------------------------------------
static const Shortint MaxCustomColors = 0x10;
#define mbYesNo (Set<TMsgDlgBtn, mbYes, mbHelp> () << TMsgDlgBtn(0) << TMsgDlgBtn(1) )
#define mbYesNoCancel (Set<TMsgDlgBtn, mbYes, mbHelp> () << TMsgDlgBtn(0) << TMsgDlgBtn(1) << TMsgDlgBtn(3) )
#define mbYesAllNoAllCancel (Set<TMsgDlgBtn, mbYes, mbHelp> () << TMsgDlgBtn(0) << TMsgDlgBtn(1) << TMsgDlgBtn(3) << TMsgDlgBtn(8) << TMsgDlgBtn(9) )
#define mbOKCancel (Set<TMsgDlgBtn, mbYes, mbHelp> () << TMsgDlgBtn(2) << TMsgDlgBtn(3) )
#define mbAbortRetryIgnore (Set<TMsgDlgBtn, mbYes, mbHelp> () << TMsgDlgBtn(4) << TMsgDlgBtn(5) << TMsgDlgBtn(6) )
#define mbAbortIgnore (Set<TMsgDlgBtn, mbYes, mbHelp> () << TMsgDlgBtn(4) << TMsgDlgBtn(6) )
extern PACKAGE bool ForceCurrentDirectory;
extern PACKAGE Forms::TForm* __fastcall CreateMessageDialog(const AnsiString Msg, TMsgDlgType DlgType, TMsgDlgButtons Buttons, TMsgDlgBtn DefaultButton)/* overload */;
extern PACKAGE Forms::TForm* __fastcall CreateMessageDialog(const AnsiString Msg, TMsgDlgType DlgType, TMsgDlgButtons Buttons)/* overload */;
extern PACKAGE int __fastcall MessageDlg(const AnsiString Msg, TMsgDlgType DlgType, TMsgDlgButtons Buttons, int HelpCtx)/* overload */;
extern PACKAGE int __fastcall MessageDlg(const AnsiString Msg, TMsgDlgType DlgType, TMsgDlgButtons Buttons, int HelpCtx, TMsgDlgBtn DefaultButton)/* overload */;
extern PACKAGE int __fastcall MessageDlgPos(const AnsiString Msg, TMsgDlgType DlgType, TMsgDlgButtons Buttons, int HelpCtx, int X, int Y)/* overload */;
extern PACKAGE int __fastcall MessageDlgPos(const AnsiString Msg, TMsgDlgType DlgType, TMsgDlgButtons Buttons, int HelpCtx, int X, int Y, TMsgDlgBtn DefaultButton)/* overload */;
extern PACKAGE int __fastcall MessageDlgPosHelp(const AnsiString Msg, TMsgDlgType DlgType, TMsgDlgButtons Buttons, int HelpCtx, int X, int Y, const AnsiString HelpFileName)/* overload */;
extern PACKAGE int __fastcall MessageDlgPosHelp(const AnsiString Msg, TMsgDlgType DlgType, TMsgDlgButtons Buttons, int HelpCtx, int X, int Y, const AnsiString HelpFileName, TMsgDlgBtn DefaultButton)/* overload */;
extern PACKAGE void __fastcall ShowMessage(const AnsiString Msg);
extern PACKAGE void __fastcall ShowMessageFmt(const AnsiString Msg, System::TVarRec * Params, const int Params_Size);
extern PACKAGE void __fastcall ShowMessagePos(const AnsiString Msg, int X, int Y);
extern PACKAGE bool __fastcall InputQuery(const AnsiString ACaption, const AnsiString APrompt, AnsiString &Value);
extern PACKAGE AnsiString __fastcall InputBox(const AnsiString ACaption, const AnsiString APrompt, const AnsiString ADefault);
extern PACKAGE bool __fastcall PromptForFileName(AnsiString &AFileName, const AnsiString AFilter = "", const AnsiString ADefaultExt = "", const AnsiString ATitle = "", const AnsiString AInitialDir = "", bool SaveDialog = false);

}	/* namespace Dialogs */
using namespace Dialogs;
#pragma pack(pop)
#pragma option pop

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// Dialogs
